/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.GrantManager;
import com.mckoi.database.Privileges;
import com.mckoi.database.SchemaDef;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.interpret.Statement;
import java.util.ArrayList;

public class PrivManager
extends Statement {
    public void prepare() throws DatabaseException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table evaluate() throws DatabaseException {
        String grant_param;
        int grant_object;
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        String command_type = (String)this.cmd.getObject("command");
        ArrayList priv_list = (ArrayList)this.cmd.getObject("priv_list");
        String priv_object = (String)this.cmd.getObject("priv_object");
        if (priv_object.startsWith("T:")) {
            String table_name_str = priv_object.substring(2);
            TableName table_name = this.database.resolveTableName(table_name_str);
            if (!this.database.tableExists(table_name)) {
                throw new DatabaseException("Table '" + table_name + "' doesn't exist.");
            }
            grant_object = 1;
            grant_param = table_name.toString();
        } else {
            if (!priv_object.startsWith("S:")) throw new Error("Priv object formatting error.");
            String schema_name_str = priv_object.substring(2);
            SchemaDef schema_name = this.database.resolveSchemaName(schema_name_str);
            if (schema_name == null || !this.database.schemaExists(schema_name.toString())) {
                schema_name_str = schema_name == null ? schema_name_str : schema_name.toString();
                throw new DatabaseException("Schema '" + schema_name_str + "' doesn't exist.");
            }
            grant_object = 65;
            grant_param = schema_name.toString();
        }
        if (command_type.equals("GRANT")) {
            String name;
            int i;
            ArrayList grant_to = (ArrayList)this.cmd.getObject("grant_to");
            boolean grant_option = this.cmd.getBoolean("grant_option");
            GrantManager manager = context.getGrantManager();
            Privileges options_privs = manager.userGrantOptions(grant_object, grant_param, this.user.getUserName());
            Privileges grant_privs = Privileges.EMPTY_PRIVS;
            for (i = 0; i < priv_list.size(); ++i) {
                int priv_bit;
                String priv = ((String)priv_list.get(i)).toUpperCase();
                if (priv.equals("ALL")) {
                    if (grant_object == 1) {
                        priv_bit = Privileges.TABLE_ALL_PRIVS.toInt();
                    } else {
                        if (grant_object != 65) throw new Error("Unrecognised grant object.");
                        priv_bit = Privileges.SCHEMA_ALL_PRIVS.toInt();
                    }
                } else {
                    priv_bit = Privileges.parseString(priv);
                }
                if (!options_privs.permits(priv_bit)) {
                    throw new UserAccessException("User is not permitted to grant '" + priv + "' access on object " + grant_param);
                }
                grant_privs = grant_privs.add(priv_bit);
            }
            for (i = 0; i < grant_to.size(); ++i) {
                name = (String)grant_to.get(i);
                if (name.equalsIgnoreCase("public") || this.database.getDatabase().userExists(context, name)) continue;
                throw new DatabaseException("User '" + name + "' doesn't exist.");
            }
            for (i = 0; i < grant_to.size(); ++i) {
                name = (String)grant_to.get(i);
                if (name.equalsIgnoreCase("public")) {
                    manager.addGrant(grant_privs, grant_object, grant_param, "@PUBLIC", grant_option, this.user.getUserName());
                    continue;
                }
                manager.addGrant(grant_privs, grant_object, grant_param, name, grant_option, this.user.getUserName());
            }
            return FunctionTable.resultTable(context, 0);
        } else {
            int i;
            if (!command_type.equals("REVOKE")) throw new Error("Unknown priv manager command: " + command_type);
            ArrayList revoke_from = (ArrayList)this.cmd.getObject("revoke_from");
            boolean revoke_grant_option = this.cmd.getBoolean("revoke_grant_option");
            GrantManager manager = context.getGrantManager();
            Privileges revoke_privs = Privileges.EMPTY_PRIVS;
            for (i = 0; i < priv_list.size(); ++i) {
                int priv_bit;
                String priv = ((String)priv_list.get(i)).toUpperCase();
                if (priv.equals("ALL")) {
                    if (grant_object == 1) {
                        priv_bit = Privileges.TABLE_ALL_PRIVS.toInt();
                    } else {
                        if (grant_object != 65) throw new Error("Unrecognised grant object.");
                        priv_bit = Privileges.SCHEMA_ALL_PRIVS.toInt();
                    }
                } else {
                    priv_bit = Privileges.parseString(priv);
                }
                revoke_privs = revoke_privs.add(priv_bit);
            }
            for (i = 0; i < revoke_from.size(); ++i) {
                String name = (String)revoke_from.get(i);
                if (name.equalsIgnoreCase("public")) {
                    manager.removeGrant(revoke_privs, grant_object, grant_param, "@PUBLIC", revoke_grant_option, this.user.getUserName());
                    continue;
                }
                manager.removeGrant(revoke_privs, grant_object, grant_param, name, revoke_grant_option, this.user.getUserName());
            }
        }
        return FunctionTable.resultTable(context, 0);
    }
}

